package mcfall.math;

/**
 * A <B>SquareMatrix</B> is a <B>Matrix</B> that has the same number of rows as columns.  Additional operations
 * are defined on square matrices, such as  
 * @author mcfall
 *
 */
public class SquareMatrix extends Matrix {
	/**
	 * Creates a square matrix with <i>size</i> rows and <i>size</i> columns.
	 * All initial data values are 0; the indices of the first row and column
	 * are both set to 1
	 * @param size the number of rows and columns in the matrix
	 */
	public SquareMatrix (int size) {
		super (size, size);		
	}
	
	/**
	 * Creates a square matrix with <i>size</i> rows and <i>size</i> columns.
	 * The initial values of the matrix are specified by the <i>values</i>
	 * parameter.  The indices of the first row and column are both set
	 * to 1.
	 * @param size
	 * @param values
	 */
	public SquareMatrix (int size, double[][] values) {
		super (size, size, values);
	}

	
}
